<?php

namespace App\Providers;

use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use \App\Events\SubscriptionCreated;
use \App\Events\SubscriptionCharged;
use \App\Events\SubscriptionUpdated;
use \App\Events\SubscriptionCancelled;
use \App\Events\SubscriptionPaymentFailed;
use \App\Listeners\HandleSubscriptionEvents;

use Musonza\Chat\Eventing\MessageWasSent;
use \App\Listeners\SendPushNotificationListener;

class EventServiceProvider extends ServiceProvider
{
  /**
   * The event listener mappings for the application.
   *
   * @var array<class-string, array<int, class-string>>
   */
  protected $listen = [
    Registered::class => [SendEmailVerificationNotification::class,],
    SubscriptionCreated::class => [HandleSubscriptionEvents::class . '@onCreated'],
    SubscriptionCharged::class => [HandleSubscriptionEvents::class . '@onCharged'],
    SubscriptionUpdated::class => [HandleSubscriptionEvents::class . '@onUpdated'],
    SubscriptionCancelled::class => [HandleSubscriptionEvents::class . '@onCancelled'],
    SubscriptionPaymentFailed::class => [HandleSubscriptionEvents::class . '@onFailed'],
    MessageWasSent::class => [SendPushNotificationListener::class],
  ];

  /**
   * Register any events for your application.
   *
   * @return void
   */
  public function boot()
  {
    //
  }
}
