<?php

namespace App\Observers;

use App\Models\User;
use Illuminate\Support\Facades\Cache;

class UserObserver
{
  /**
   * Handle events after a user is created or updated.
   */
  public function saved(User $user)
  {
    cacheForget("driver_{$user->driverId}", ['drivers']);
    cacheForget('active_drivers', ['drivers']);
    cacheForget('map_drivers', ['users']);
    cacheForget('dropdown_drivers', ['drivers']);
    cacheForget('dashboard_user_stats', ['dashboard']);
    cacheForget('dashboard_driver_stats', ['dashboard']);
    cacheForget('dashboard_store_stats', ['dashboard']);
  }

  /**
   * Handle events after a user is deleted.
   */
  public function deleted(User $user)
  {
    cacheForget('map_drivers', ['users']);
    cacheForget('dashboard_user_stats', ['dashboard']);
    cacheForget('dashboard_driver_stats', ['dashboard']);
    cacheForget('dashboard_store_stats', ['dashboard']);
  }
}
