<?php

namespace App\Observers;
use App\Helpers\Helpers;
use App\Models\Driver;
use Illuminate\Support\Facades\Cache;

class DriverObserver
{
  /**
   * Handle events after a driver is created or updated.
   */
  public function saved(Driver $driver)
  {
    // Get the fields that were changed
    $changed = $driver->getDirty(); // returns only modified attributes
    // Exclude latitude and longitude
    $changed = array_diff_key($changed, array_flip(['latitude', 'longitude']));
    // If other fields changed, clear cache
    if (!empty($changed)) {
      cacheForget("driver_{$driver->id}", ['drivers']);
      cacheForget('active_drivers', ['drivers']);
      cacheForget('dropdown_drivers', ['drivers']);
      cacheForget('dashboard_driver_stats', ['dashboard']);
    }
  }

  /**
   * Handle events after a driver is deleted.
   */
  public function deleted(Driver $driver)
  {
    // Clear cache for this driver
    cacheForget("driver_{$driver->id}", ['drivers']);
    cacheForget('active_drivers', ['drivers']);
    cacheForget('dropdown_drivers', ['drivers']);
  }
  public function updating(Driver $driver)
  {
    // List of driver fields that trigger unverify
    $fieldsToCheck = ['license_number', 'license_expiry', 'license_image'];
    foreach ($fieldsToCheck as $field) {
      if ($driver->isDirty($field)) {
        $driver->is_verified = 0;
        $driver->save();
        $url = 'drivers/' . $driver->id;
        $message = 'License Details of driver was updated. Please verify the driver.';
        Helpers::adminNotification("Driver Details Updated", 'App\Notifications\Driver', $message, $driver->id, $url, $driver->id);
        break;
      }
    }
  }
}
