<?php
namespace App\Models;
class WalletTransaction extends BaseModel
{

  protected $fillable = ['wallet_id', 'order_type', 'order_id', 'amount', 'type', 'payment_mode', 'status', 'description', 'idempotency_key'];
  public function wallet()
  {
    return $this->belongsTo(Wallet::class);
  }
  public function order()
  {
    return $this->morphTo(__FUNCTION__, 'order_type', 'order_id')->withTrashed();
  }

}
