<?php
namespace App\Models;
class VehicleModel extends BaseModel
{
  protected $fillable = ['vehicle_parent_id', 'vehicle_category_id', 'vehicle_brand_id', 'name', 'image', 'status'];
  protected $appends = ['delete_url', 'status_url', 'parent_category', 'vehicle_category', 'vehicle_brand'];

  protected static function boot()
  {
    parent::boot();
    static::deleting(function ($model) {
      if ($model->vehicles()->exists()) {
        throw new \Exception('Cannot delete model with associated vehicles.');
      }
    });
  }
  // Returns parent category name
  public function getParentCategoryAttribute()
  {
    return $this->parentCategory()->first()?->name;
  }

  // Returns vehicle category name
  public function getVehicleCategoryAttribute()
  {
    return $this->vehicleCategory()->first()?->name;
  }

  // Returns vehicle brand name
  public function getVehicleBrandAttribute()
  {
    return $this->vehicleBrand()->first()?->name;
  }

  public function getDeleteUrlAttribute()
  {
    $prefix = request()->segment(1);
    return url("{$prefix}/vehicle-models/{$this->id}");
  }
  public function getStatusUrlAttribute()
  {
    $prefix = request()->segment(1);
    return url("{$prefix}/vehicle-models/changestatus");
  }

  public function vehicleCategory()
  {
    return $this->belongsTo(VehicleCategory::class, 'vehicle_category_id');
  }

  public function parentCategory()
  {
    return $this->belongsTo(VehicleCategory::class, 'vehicle_parent_id');
  }

  public function vehicleBrand()
  {
    return $this->belongsTo(VehicleBrand::class, 'vehicle_brand_id');
  }

  public function vehicles()
  {
    return $this->hasMany(Vehicle::class, 'vehicle_model_id');
  }
}
