<?php
namespace App\Models;
class VehicleBrand extends BaseModel
{
  protected $fillable = ['name', 'image', 'status'];
  protected $appends = ['delete_url', 'status_url'];
  protected static function boot()
  {
    parent::boot();
    static::deleting(function ($brand) {
      if ($brand->vehicles()->exists()) {
        throw new \Exception(__('locale.Cannot delete brand with associated vehicles.'));
      }
      // Delete all vehicle models under brand (only if no vehicles)
      $brand->models->each(function ($model) {
        if ($model->vehicles()->exists()) {
          throw new \Exception(__('locale.Cannot delete brand because a model has vehicles.'));
        }
        $model->delete();
      });
    });
  }

  public function getDeleteUrlAttribute()
  {
    $prefix = request()->segment(1);
    return url("{$prefix}/vehicle-brands/{$this->id}");
  }
  public function getStatusUrlAttribute()
  {
    $prefix = request()->segment(1);
    return url("{$prefix}/vehicle-brands/changestatus");
  }

  public function models()
  {
    return $this->hasMany(VehicleModel::class, 'vehicle_brand_id');
  }
  public function vehicles()
  {
    return $this->hasMany(Vehicle::class, 'vehicle_brand_id');
  }
}
