<?php

namespace App\Models;
class Ride extends BaseModel
{
  protected $fillable = ['user_id', 'driver_id', 'ride_id', 'vehicle_category_id', 'pickup_location', 'drop_location', 'pickup_lat', 'pickup_lng', 'drop_lat', 'drop_lng', 'fare', 'currency', 'trip_distance', 'trip_time', 'rating', 'platform_commission', 'payment_type', 'payment_status', 'status', 'type', 'details', 'invoice_details', 'ride_otp', 'departure_time', 'arrived_time', 'sender_name', 'receiver_name', 'receiver_phone', 'parcel_category_id', 'package_details', 'order_id', 'cancelled_by', 'cancelled_message', 'cancel_time', 'driver_ride_accept_lat', 'driver_ride_accept_lng'];
  public function reviews()
  {
    return $this->morphOne(Review::class, 'reviewable');
  }
  public function user()
  {
    return $this->belongsTo(User::class)->withTrashed();
  }
  public function driver()
  {
    return $this->belongsTo(Driver::class);
  }
  public function transaction()
  {
    return $this->morphOne(Transaction::class, 'transactionable');
  }
  public function order()
  {
    return $this->belongsTo(Order::class);
  }
  public function parcelCategory()
  {
    return $this->belongsTo(ParcelCategory::class)->withTrashed();
  }

  public function statusLogs()
  {
    return $this->morphMany(StatusLog::class, 'trackable');
  }
  public function waitingTimes()
  {
    return $this->hasMany(RideWaitingTime::class);
  }

}
