<?php
namespace App\Models;
use Illuminate\Database\Eloquent\SoftDeletes;
class Product extends BaseModel
{
  use SoftDeletes; // ✅ Add SoftDeletes
  protected $fillable = ['store_id', 'category_id', 'title', 'sku', 'description', 'price', 'discounted_price', 'in_stock', 'is_non_veg', 'tags', 'rating', 'rating_count', 'prescriptions', 'currency', 'status'];
  public function store()
  {
    return $this->belongsTo(Store::class);
  }
  public function images()
  {
    return $this->hasMany(ProductImage::class);
  }

  public function image()
  {
    return $this->hasOne(ProductImage::class);
  }
  public function category()
  {
    return $this->belongsTo(Category::class);
  }
  public function orders()
  {
    return $this->hasMany(OrderItem::class);
  }
  public function getOrdersCountAttribute()
  {
    return $this->orders()->count();
  }
  public function getOrdersQuantitySumAttribute()
  {
    return $this->orders()->sum('quantity');
  }
  public function favorites()
  {
    return $this->morphMany(Favorite::class, 'favoritable');
  }
  public function orderItems()
  {
    return $this->hasMany(OrderItem::class, 'product_id');
  }

}
