<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
class ParcelCategory extends BaseModel
{
  use HasFactory, SoftDeletes; // ✅ Add SoftDeletes

  protected $fillable = [
    'name',
    'description',
    'image',
    'parent_id',
    'status',
  ];
  protected $appends = ['parent_name', 'delete_url', 'status_url'];

  public function parent()
  {
    return $this->belongsTo(ParcelCategory::class, 'parent_id');
  }

  public function children()
  {
    return $this->hasMany(ParcelCategory::class, 'parent_id');
  }

  // Recursive children
  public function childrenRecursive()
  {
    return $this->children()->with('childrenRecursive');
  }

  public function getParentNameAttribute()
  {
    return $this->parent ? $this->parent->name : '';
  }
  public function getDeleteUrlAttribute()
  {
    $prefix = request()->segment(1);
    return url("{$prefix}/parcel-categories/{$this->id}");
  }
  public function getStatusUrlAttribute()
  {
    $prefix = request()->segment(1);
    return url("{$prefix}/parcel-categories/changestatus");
  }

}
