<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
class Package extends BaseModel
{
  use HasFactory, SoftDeletes; // ✅ Add SoftDeletes

  protected $fillable = [
    'name',
    'description',
    'duration_id',
    'price',
    'status',
    'type',
    'ios_subscription_id',
    'android_subscription_id',
  ];
  protected $appends = ['delete_url', 'status_url'];

  public function duration()
  {
    return $this->belongsTo(Duration::class);
  }
  public function getDeleteUrlAttribute()
  {
    $prefix = request()->segment(1);
    return url("{$prefix}/packages/{$this->id}");
  }
  public function getStatusUrlAttribute()
  {
    $prefix = request()->segment(1);
    return url("{$prefix}/packages/changestatus");
  }
  public function transactions()
  {
    return $this->morphMany(Transaction::class, 'transactionable');
  }

}
