<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DriverBlockLog extends Model
{
  use HasFactory;

  protected $fillable = [
    'driver_id',
    'block_type',
    'reason',
    'ride_id',
    'blocked_at',
    'unblocked_at',
  ];

  public function driver()
  {
    return $this->belongsTo(User::class, 'driver_id');
  }

  public function ride()
  {
    return $this->belongsTo(Ride::class, 'ride_id');
  }
}
