<?php

namespace App\Models;
class Country extends BaseModel
{
  protected $fillable = [
    'sortname',
    'timezone',
    'name',
    'dial_code',
    'currency_code',
    'currency_symbol',
    'base_fare',
    'per_km_rate',
    'per_minute_price',
    'status',
  ];
  protected $appends = ['status_url'];
  public function vehicleCategories()
  {
    return $this->belongsToMany(VehicleCategory::class, 'country_vehicle_category')->withPivot('base_fare', 'per_km_rate', 'per_minute_price', 'per_minute_waiting_price');
  }

  public function getStatusUrlAttribute()
  {
    $prefix = request()->segment(1);
    return url("{$prefix}/countries/changestatus");
  }
}
