<?php
namespace App\Models;

class Car extends BaseModel
{
  protected $fillable = ['vehicle_parent_category_id', 'vehicle_category_id', 'vehicle_brand_id', 'vehicle_model_id', 'vehicle_data', 'vehicle_year', 'vehicle_color', 'registration_number', 'license_plate', 'vehicle_image', 'insurance_image', 'road_worthiness_image', 'vehicle_registration_image', 'status'];
  protected $appends = ['delete_url', 'status_url', 'parent_category', 'vehicle_category', 'vehicle_brand', 'vehicle_model', 'color'];
  protected static function boot()
  {
    parent::boot();
    static::deleting(function ($car) {
      // Check if rentals exist for this car
      if ($car->rentals()->exists()) {
        throw new \Exception(__('locale.Cannot delete car with associated rentals.'));
      }
    });
  }
  public function rentals()
  {
    return $this->hasMany(Rental::class);
  }
  public function getParentCategoryAttribute()
  {
    return $this->parentCategory()->first()?->name;
  }
  public function getVehicleCategoryAttribute()
  {
    return $this->vehicleCategory()->first()?->name;
  }
  public function getVehicleBrandAttribute()
  {
    return $this->vehicleBrand()->first()?->name;
  }
  public function getVehicleModelAttribute()
  {
    return $this->vehicleModel()->first()?->name;
  }
  public function getColorAttribute()
  {
    $color = $this->vehicleColor; // avoid ->first() if it's a belongsTo
    return $color ? [
      'name' => $color->name,
      'code' => $color->code,
    ] : null;
  }
  public function getDeleteUrlAttribute()
  {
    $prefix = request()->segment(1);
    return url("{$prefix}/vehicles/{$this->id}");
  }
  public function getStatusUrlAttribute()
  {
    $prefix = request()->segment(1);
    return url("{$prefix}/vehicles/changestatus");
  }
  public function vehicleCategory()
  {
    return $this->belongsTo(VehicleCategory::class, 'vehicle_category_id');
  }
  public function parentCategory()
  {
    return $this->belongsTo(VehicleCategory::class, 'vehicle_parent_category_id');
  }
  public function vehicleBrand()
  {
    return $this->belongsTo(VehicleBrand::class, 'vehicle_brand_id');
  }
  public function vehicleModel()
  {
    return $this->belongsTo(VehicleModel::class, 'vehicle_model_id');
  }
  public function vehicleColor()
  {
    return $this->belongsTo(Color::class, 'vehicle_color');
  }
}
