<?php
namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Models\Driver;
use Illuminate\Support\Facades\Log;

class UpdateDriverLocationJob implements ShouldQueue
{
  use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

  public $driverId;
  public $lat;
  public $lng;

  public function __construct($driverId, $lat, $lng)
  {
    $this->driverId = $driverId;
    $this->lat = $lat;
    $this->lng = $lng;
  }

  public function handle()
  {
    //Log::info("Updating driver {$this->driverId} to {$this->lat},{$this->lng}");
    Driver::where('id', $this->driverId)
      ->update([
        'latitude' => $this->lat,
        'longitude' => $this->lng,
        'updated_at' => now()
      ]);
  }
}
