<?php
namespace App\Jobs;
use App\Models\Driver;
use App\Models\DriverBlockLog;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class DriverUnblockJob implements ShouldQueue
{
  use Dispatchable, Queueable;

  protected $driverId;

  public function __construct($driverId)
  {
    $this->driverId = $driverId;
  }

  public function handle()
  {
    $driver = Driver::find($this->driverId);
    if ($driver && $driver->is_blocked == 1) { // only unblock 24hr blocks
      $driver->is_blocked = 0;
      $driver->blocked_until = null;
      $driver->save();
      DriverBlockLog::create([
        'driver_id' => $driver->id,
        'block_type' => 0,
        'reason' => '24hr block expired',
        'ride_id' => null,
        'unblocked_at' => now(),
      ]);
    }
  }
}
