<?php

namespace App\Http\Responses;
use Laravel\Fortify\Contracts\LoginResponse as LoginResponseContract;
use Illuminate\Support\Facades\Auth;
class LoginResponse implements LoginResponseContract
{
  /**
   * @param  $request
   * @return mixed
   */
  public function toResponse($request)
  {
    $user = Auth::user();
    // Redirect by user type
    $home = match ($user->user_type) {
      'Admin' => '/admin/dashboard',
      'Store' => '/store/dashboard',
      default => '/dashboard',
    };

    return redirect()->intended($home);
  }

}
