<?php

namespace App\Http\Resources;
use App\Helpers\Helpers;
use Illuminate\Http\Resources\Json\ResourceCollection;

class WithdrawalRequestCollection extends ResourceCollection
{
  public function toArray($request)
  {
    $currency = cache()->remember('currency_symbol', 3600, fn() => Helpers::setting('currency_symbol', 'currency'));

    return [
      'data' => $this->collection->map(function ($data) use ($currency) {
        return [
          'id' => (int) $data->id,
          'name' => $data->user?->name ?? '',
          'phone' => $data->user?->dial_code . $data->user?->phone,
          'amount' => $data->amount,
          'total_amount' => $data->total_amount,
          'processing_fees' => $data->processing_fees,
          'currency' => $data->currency ?? $currency,
          'date_time' => $data->created_at?->format('d M, h:i a'),
          'status' => $data->status,
          'processed_at' => $data->processed_at,
          'notes' => $data->notes,
          'txn_id' => $data->txn_id ?? '',
        ];
      }),
    ];
  }


  public function with($request)
  {
    return [
      'success' => true,
      'status' => 200
    ];
  }
}
