<?php

namespace App\Http\Resources;
use Illuminate\Http\Resources\Json\ResourceCollection;
class UserProfileCollection extends ResourceCollection
{
  public function toArray($request)
  {
    $data = $this->collection[0];
    return [
      'id' => (integer) $data->id,
      'name' => $data->name,
      'user_type' => $data->user_type,
      'email' => $data->email,
      'email_verified' => empty($data->email_verified_at) ? false : true,
      'dial_code_iso' => $data->dial_code_iso,
      'phone' => $data->phone,
      'avatar' => $data->profile_photo_url,
      'fcm_token' => $data->fcm_token,
      'referral_code' => $data->referral_code,
      'start_date' => $data->start_date,
      'end_date' => $data->end_date,
      'wallet' => $data->wallet,
      'last_seen' => $data->last_seen,
      'is_verified' => $data->is_verified == 1 ? true : false,
      'created_at' => date('d-m-Y', strtotime($data->created_at)),
      'status' => $data->status == 1 ? 'Enable' : 'Disable',
      $this->mergeWhen(!empty($data['details']), [

      ]),

    ];

  }

  public function with($request)
  {
    return [
      'success' => true,
      'status' => 200
    ];
  }



}
