<?php
namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\ProductCollection;
use App\Helpers\Helpers;

class StoreResource extends JsonResource
{
  public function toArray($request)
  {
    $data = $this;
    $base = [
      'id' => (integer) $data->id,
      'name' => $data->user?->name ?? '',
      'contact_person_name' => $data->contact_person_name ?? $data->user?->name,
      'phone' => $data->dial_code_contact . $data->contact_person_phone,
      'address' => $data->address,
      'country' => $data->country,
      'state' => $data->state,
      'city' => $data->city,
      'description' => $data->description,
      'website' => $data->website,
      'delivery_time' => $data->delivery_time,
      'image' => $data->user?->profile_photo_path ? asset('storage/' . $data->user?->profile_photo_path) : asset('assets/img/placeholder.jpg'),
    ];
    if (!($this->additional['popup'] ?? false)) {
      $base = array_merge($base, [
        'rating' => $data->rating,
        'rating_count' => Helpers::formatNumberShort($data->rating_count),
        'orders_count' => Helpers::formatNumberShort($data->orders_count),
        'is_non_veg' => $data->is_non_veg ?? false,
        'is_cod' => $data->is_cod,
        'is_online_payment' => $data->is_online_payment,
        'is_favorite' => $data->is_favorite ?? false,
        'distance' => round($data->distance, 2) . ' Km',
        'time' => Helpers::estimateDeliveryTime($data->distance, $data->delivery_time),
        'estimated_time' => $data->estimated_time,
        'show_diet_type' => $data->show_diet_type,
        'popular_products' => (new ProductCollection($data->products))->resolve()['data'],
        'menu_categories' => $this->categories($data->categories),
      ]);
    }
    if (($this->additional['popup'] ?? true)) {
      $base = array_merge($base, [
        'opening_hours' => $this->openingHours($data),
        'always_open' => $data->always_open,
      ]);
    }
    return $base;
  }

  private function categories($categories)
  {
    return $categories->map->only(['id', 'name'])->toArray();
  }
  private function openingHours($store)
  {
    // If always_open flag is set
    if ($store->always_open) {
      return 'Always Open';
    }

    // Else return business hours
    return $store->businessHours->map(function ($hour) {
      return [
        'day' => $hour->day,
        'status' => (bool) $hour->status,
        'start_time' => $hour->start_time ? date('H:i', strtotime($hour->start_time)) : '',
        'end_time' => $hour->end_time ? date('H:i', strtotime($hour->end_time)) : '',
      ];
    })->toArray();
  }


  public function with($request)
  {
    return [
      'success' => true,
      'status' => 200
    ];
  }


}
