<?php

namespace App\Http\Resources;
use App\Helpers\Helpers;
use Illuminate\Http\Resources\Json\ResourceCollection;

class StoreCollection extends ResourceCollection
{
  public function toArray($request)
  {
    return [
      'data' => $this->collection->map(function ($data) {
        return [
          'id' => (integer) $data->id,
          'name' => $data->user?->name ?? '',
          'address' => $data->address,
          'rating' => $data->rating,
          'is_favorite' => $data->is_favorite ?? false,
          'distance' => round($data->distance, 2) . ' Km',
          'time' => Helpers::estimateDeliveryTime($data->distance, $data->delivery_time),
          'estimated_time' => $data->estimated_time,
          'show_diet_type' => $data->show_diet_type,
          'image' => $data->user?->profile_photo_path ? asset('storage/' . $data->user?->profile_photo_path) : asset('assets/img/placeholder.jpg'),

        ];
      })
    ];
  }

  protected function estimateDeliveryTime(?float $distance): string
  {
    if (!$distance)
      return '';
    // Average speed in km/min (e.g., 30 km/h = 0.5 km/min)
    $avgSpeed = 0.5;
    // Base time in minutes
    $baseTime = $distance / $avgSpeed;
    // Create range +/- 20%
    $minTime = $baseTime * 1;
    $maxTime = $baseTime * 1.2;
    // Round to nearest 5
    $minTime = ceil($minTime / 5) * 5;
    $maxTime = ceil($maxTime / 5) * 5;
    return "{$minTime}-{$maxTime} Mins";
  }

  public function with($request)
  {
    return [
      'success' => true,
      'status' => 200
    ];
  }
}
