<?php

namespace App\Http\Resources;
use App\Helpers\Helpers;
use Illuminate\Support\Str;
use Illuminate\Http\Resources\Json\ResourceCollection;

class ProductCollection extends ResourceCollection
{
  public function toArray($request)
  {
    $currency = cache()->remember('currency_symbol', 3600, fn() => Helpers::setting('currency_symbol', 'currency'));
    return [
      'data' => $this->collection->map(function ($data) use ($currency) {
        return [
          'id' => (integer) $data->id,
          'title' => $data->title ?? '',
          'sku' => $data->sku,
          'description' => Str::words(strip_tags($data->description), 10, '...'),
          'rating' => $data->rating,
          'strike_price' => $data->price,
          'price' => $data->discounted_price ?? $data->price,
          'currency' => $data->currency ?? $currency,
          'is_non_veg' => $data->is_non_veg ?? false,
          'show_diet_type' => $data->show_diet_type,
          'image' => $data->images[0]->file ? asset('storage/' . $data->images[0]->file) : asset('assets/img/placeholder.jpg'),

        ];
      })
    ];
  }

  public function with($request)
  {
    return [
      'success' => true,
      'status' => 200
    ];
  }
}
