<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\ResourceCollection;

class PaginatedResourceCollection extends ResourceCollection
{
  public static $wrap = null; // disable default wrapping

  protected string $message = 'Data fetched successfully';

  public function setMessage(string $message): static
  {
    $this->message = $message;
    return $this;
  }

  public function toArray($request)
  {
    $pagination = $this->resource;

    // Handle empty pagination gracefully
    $links = [];
    $meta = [];
    if ($pagination && method_exists($pagination, 'currentPage')) {
      $links = [
        'first' => $pagination->url(1),
        'last' => $pagination->url($pagination->lastPage()),
        'prev' => $pagination->previousPageUrl(),
        'next' => $pagination->nextPageUrl(),
        'path' => $pagination->path(),
      ];

      $meta = [
        'current_page' => $pagination->currentPage(),
        'from' => $pagination->firstItem(),
        'last_page' => $pagination->lastPage(),
        'per_page' => $pagination->perPage(),
        'to' => $pagination->lastItem(),
        'total' => $pagination->total(),
      ];
    }

    return [
      'status' => 200,
      'success' => true,
      'message' => $this->message,
      'data' => [
        'data' => $this->collection->isEmpty() ? [] : $this->collection,
        'links' => $links,
        'meta' => $meta,
      ],
    ];
  }
}
