<?php

namespace App\Http\Resources;
use App\Helpers\Helpers;
use Illuminate\Http\Resources\Json\ResourceCollection;

class OrderCollection extends ResourceCollection
{
  public function toArray($request)
  {
    $currency = cache()->remember('currency_symbol', 3600, fn() => Helpers::setting('currency_symbol', 'currency'));

    return [
      'data' => $this->collection->map(function ($data) use ($currency) {
        return [
          'id' => (int) $data->id,
          'name' => $data->store?->user?->name ?? '',
          'address' => $data->store?->address,
          'rating' => $data->store?->rating,
          'orderId' => $data->order_id,
          'grand_total' => ($data->currency ?? $currency) . $data->grand_total,
          'date_time' => $data->created_at?->format('d M, h:i a'),
          'status' => $data->status,
          'payment_status' => $data->payment_status,
          'is_rateable' => empty($data->review->rating) && $data->status == 'Delivered' ? true : false,
          'you_rated' => $data->review->rating ?? '',
          'image' => $data->store?->user?->profile_photo_path
            ? asset('storage/' . $data->store?->user?->profile_photo_path)
            : asset('assets/img/placeholder.jpg'),

          // ✅ Order items
          'items' => $data->items->map(function ($item) use ($currency) {
            return [
              'id' => $item->id,
              'product_id' => $item->product_id,
              'product_name' => $item->product?->title ?? '',
              'category' => $item->product?->category?->name ?? '',
              'quantity' => $item->quantity,
              'is_non_veg' => $item->is_non_veg ?? 0,
              'price' => ($data->currency ?? $currency) . $item->price,
              'subtotal' => $data->currency ?? $currency . ($item->price * $item->quantity),
              /*     'image' => $item->product?->images[0]
                    ? asset('storage/' . $item->product?->images[0]->file)
                    : asset('assets/img/placeholder.jpg'), */
            ];
          }),
        ];
      }),
    ];
  }


  public function with($request)
  {
    return [
      'success' => true,
      'status' => 200
    ];
  }
}
