<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;

class VehicleModelRequest extends FormRequest
{
  use ApiResponseTrait;

  public function authorize()
  {
    return true;
  }

  public function rules(): array
  {
    $modelId = $this->route('vehicle_model') ?? $this->route('id');

    return [
      'name' => [
        'required',
        'unique:vehicle_models,name,' . ($modelId ?? 'NULL') . ',id',
      ],
      'image' => 'nullable|mimes:jpeg,png,jpg,webp',
      'description' => ['nullable'],
      'vehicle_parent_id' => ['required'],
      'vehicle_category_id' => ['required'],
      'vehicle_brand_id' => ['required'],
      'status' => ['nullable'],
    ];
  }

  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }
}
