<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;
class UpdateTicketRequest extends FormRequest
{
  use ApiResponseTrait;
  public function authorize(): bool
  {
    return true; // You can restrict this to certain users if needed
  }

  public function rules(): array
  {
    return [
      'message' => 'required|string|min:3',
    ];
  }

  public function messages(): array
  {
    return [
      'message.required' => 'The message field is required.',
      'message.min' => 'The message must be at least 3 characters.',
    ];
  }
  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }
}
