<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class StoreTicketRequest extends FormRequest
{
  public function authorize(): bool
  {
    return true;
  }

  public function rules(): array
  {
    return [
      'name' => 'required',
      'email' => 'required|required',
      'category' => 'required',
      'subject' => ['required', 'regex:/^[A-Za-z\s\-]+$/'],
      'message' => ['required', 'not_regex:/^(N\/A)$/i'],
    ];
  }

  public function messages(): array
  {
    return [
      'subject.regex' => __('locale.Subject can contain only letters.'),
      'message.not_regex' => __('locale.Description cannot contain special characters.'),
    ];
  }

  protected function prepareForValidation()
  {
    $this->replace(array_map('strtolower', $this->all()));
  }

  /*   protected function failedValidation(Validator $validator)
    {
      session()->flash('error', implode(' ', $validator->errors()->all()));
      throw new HttpResponseException(
        redirect('contact-us')->withErrors($validator)->withInput()
      );
    } */

  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }
}
