<?php

namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;
class StoreEmailRequest extends FormRequest
{
  use ApiResponseTrait;
  public function authorize(): bool
  {
    return true; // Allow all, or customize your auth logic here
  }

  public function rules(): array
  {
    return [
      'message_type' => 'required|string',
      'type' => 'required|string',
      'subject' => 'required|string|max:255',
      'message' => 'required|string',
      'emails' => 'required|array',
      'emails.*' => 'required',
    ];
  }

  public function messages(): array
  {
    return [
      'message_type.required' => 'Message type is required.',
      'type.required' => 'Type is required.',
      'subject.required' => 'Subject is required.',
      'message.required' => 'Message is required.',
      'emails.*.required' => 'Each email is required.',
      //'emails.*.email' => 'Each email must be a valid email address.',
    ];
  }

  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }
}
