<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;
use App\Rules\PhoneNumber;
class RoleRequest extends FormRequest
{
  use ApiResponseTrait;
  public function authorize(): bool
  {
    return true; // or add your auth logic
  }

  public function rules(): array
  {
    $userId = $this->input('id');
    return [
      'name' => 'required|min:3',
      'email' => [
        'required',
        'unique:users,email,' . ($userId ?? 'NULL') . ',id',
      ],
      'phone' => [
        'nullable',
        'min:4',
        'max:17',
        new PhoneNumber($this->input('dial_code')),
        'unique:users,phone,' . ($userId ?? 'NULL') . ',id',
      ],
      'roles' => 'required',
      'password' => $userId ? 'nullable|min:6' : 'required|min:6',
    ];
  }

  public function messages(): array
  {
    return [

    ];
  }

  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }


}
