<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;
class RidePricingRuleRequest extends FormRequest
{
  use ApiResponseTrait;
  public function authorize(): bool
  {
    return true; // or add your auth logic
  }

  public function rules(): array
  {
    $this->route('ride_pricing_rule') ?? $this->route('id');
    return [
      'country_id' => 'required|integer',
      'rule_name' => 'required|string|max:255',
      'price_type' => 'required|in:flat,multiplier,discount,percent',
      'amount' => 'required|numeric',
      'priority' => 'required|integer',
      'is_active' => 'boolean',
      'conditions' => 'nullable|array',
      'conditions.*.type' => 'sometimes|required|string|in:day_of_week,month,time_range,date',
      'conditions.*.value' => [
        'nullable',
        function ($attribute, $value, $fail) {
          if (!is_string($value) && !is_array($value)) {
            $fail("The {$attribute} must be a string or an array.");
          }
        }
      ],
    ];
  }

  public function messages(): array
  {
    return [

    ];
  }

  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }


}
