<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;
use App\Rules\PhoneNumber;
class ProductRequest extends FormRequest
{
  use ApiResponseTrait;
  public function authorize(): bool
  {
    return true; // or add your auth logic
  }

  public function rules(): array
  {
    $productId = $this->input('product_id');

    return [
      'title' => 'required|string|min:3|max:255',
      'description' => 'nullable|string',
      'price' => 'required|numeric|min:0',
      'discounted_price' => 'nullable|numeric|min:0|lte:price',
      'in_stock' => 'nullable',
      'status' => 'required|in:0,1',
      'category' => 'required|exists:categories,id',
      'product_tags' => 'nullable|string', // Comma-separated tags
      'images.*' => ($productId ? 'nullable' : 'required') . '|string', // or use 'image' if uploading files directly
    ];
  }

  public function messages(): array
  {
    return [

    ];
  }

  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }


}
