<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;

class PackageRequest extends FormRequest
{
  use ApiResponseTrait;

  public function authorize()
  {
    return true;
  }

  public function rules(): array
  {
    $packageId = $this->route('package') ?? $this->route('id');

    return [
      'name' => [
        'required',
        'unique:packages,name,' . ($packageId ?? 'NULL') . ',id',
      ],
      'price' => ['required'],
      'type' => ['required'],
      'duration_id' => ['required'],
      'ios_subscription_id' => ['nullable'],
      'android_subscription_id' => ['nullable'],
      'description' => ['nullable'],
      'status' => ['required'],
    ];
  }

  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }
}
