<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Contracts\Validation\Validator;
use App\Traits\ApiResponseTrait;
class LoginRequest extends FormRequest
{
  use ApiResponseTrait;
  public function authorize()
  {
    return true;
  }

  public function rules()
  {

    $rules = [
      'phone' => 'required',
      'dial_code' => 'required',
      //'email' => 'required',
      'password' => 'required|min:6|max:15',
      'fcm_token' => 'required',
      'user_type' => 'required',
    ];
    return $rules;
  }


  public function messages()
  {
    return [
      '*.required' => 'The :attribute field is required.',
      '*.required_if' => 'The :attribute field is required when :other is :value.',
      '*.email' => 'The :attribute must be a valid email address.',
      '*.unique' => 'The :attribute has already been taken.',
      '*.confirmed' => 'The :attribute confirmation does not match.',
      'password.regex' => 'Your password should contain at-least 1 Uppercase, 1 Lowercase, 1 Numeric and 1 special character.',
    ];
  }

  public function attributes()
  {
    return [
      'phone' => 'Phone',
      'password' => 'Password',
      'fcm_token' => 'FCM TOKEN',

    ];
  }


  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }

  /*  $returnType = $this->input('returnType'); // or use $this->get('returnType')
      if ($returnType === 'session') {
        throw new HttpResponseException(
          back()->withErrors($validator)->withInput(),
        );
      } else {
        //code in failedValidation
        } */
}
