<?php

namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Contracts\Validation\Validator;
use App\Traits\ApiResponseTrait;
class ChangePasswordRequest extends FormRequest
{
  use ApiResponseTrait;
  public function authorize()
  {
    return true;
  }

  public function rules()
  {

    $rules = [
      'old_password' => 'required| min:6',
      'password' => 'required|max:15|min:6|same:confirm_password',
      'confirm_password' => 'required|max:15|min:6|same:password',
    ];
    //regex:/^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9])(?=.*?[#?!@$%^&*-]).{6,}$/
    return $rules;
  }


  public function messages()
  {
    return [
      '*.required' => 'The :attribute field is required.',
      '*.required_if' => 'The :attribute field is required when :other is :value.',
      '*.email' => 'The :attribute must be a valid email address.',
      '*.unique' => 'The :attribute has already been taken.',
      '*.confirmed' => 'The :attribute confirmation does not match.',
      'password.regex' => 'Your password should contain at-least 1 Uppercase, 1 Lowercase, 1 Numeric and 1 special character.',
    ];
  }

  public function attributes()
  {
    return [
      'old_password' => 'Old Password',
      'new_password' => 'New Password',
      'confirm_password' => 'Confirm Password',

    ];
  }


  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }
}
