<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;

class CarRequest extends FormRequest
{
  use ApiResponseTrait;
  public function authorize(): bool
  {
    return true; // or add your auth logic
  }

  public function rules(): array
  {
    $carId = $this->input('id');
    return [
      // Vehicle details
      'registration_number' => [
        'required',
        'unique:cars,registration_number,' . ($carId ?? 'NULL') . ',id',
      ],
      'vehicle_parent_category_id' => 'required|exists:vehicle_categories,id',
      'vehicle_category_id' => 'required|exists:vehicle_categories,id',
      'vehicle_model_id' => 'required|exists:vehicle_models,id',
      'vehicle_color' => 'required',
      'vehicle_year' => 'required',
      'vehicle_image' => ($carId ? 'nullable' : 'required') . '|image',
      // Documents
      'insurance_image' => ($carId ? 'nullable' : 'required') . '|image',
      'vehicle_registration_image' => ($carId ? 'nullable' : 'required') . '|image',
      'road_worthiness_image' => ($carId ? 'nullable' : 'nullable') . '|image',
    ];
  }

  public function messages(): array
  {
    return [

    ];
  }

  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }
}
