<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;
class CalendarEventRequest extends FormRequest
{
  use ApiResponseTrait;
  public function authorize(): bool
  {
    return true; // or add your auth logic
  }

  public function rules(): array
  {
    return [
      'title' => 'required|string|max:255',
      'description' => 'required|string',
      'start' => 'required|date',
      'end' => 'required|date|after_or_equal:start',
      'calendar' => 'required|string',
    ];
  }

  public function messages(): array
  {
    return [
      'title.required' => 'The Event title is required.',
      'description.required' => 'The description is required.',
      'start.required' => 'Start date is required.',
      'end.required' => 'End date is required.',
      'calendar.required' => 'Event type is required.',
    ];
  }


  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }

}
