<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ApiResponseTrait;

class AddressRequest extends FormRequest
{
  use ApiResponseTrait;

  public function authorize()
  {
    return true;
  }

  public function rules(): array
  {
    return [
      'name' => 'required',
      'address' => ['required'],
      'country_id' => ['required'],
      'state_id' => ['required'],
      'city_id' => ['required'],
      'postcode' => ['required'],
      'type' => ['required'],
      'status' => ['nullable', 'boolean'],
      'id' => 'nullable',
      'latitude' => 'required',
      'longitude' => 'required',
    ];
  }

  public function failedValidation(Validator $validator)
  {
    $errors = $validator->errors()->all();
    $message = implode("\n", $errors);
    throw new HttpResponseException(
      $this->unprocessableResponse($errors, $message),
    );
  }
}
