<?php
namespace App\Http\Middleware;
use Closure;
use Illuminate\Support\Facades\Auth;
use App\Enums\UserType;
class RedirectIfNotStore
{

  /**
   * Handle an incoming request.
   *
   * @param  \Illuminate\Http\Request  $request
   * @param  \Closure  $next
   * @param  string|null  $guard
   * @return mixed
   */
  public function handle($request, Closure $next, $guard = 'web')
  {
    if (!Auth::guard($guard)->check()) {
      return redirect('login');
    } else {
      if (Auth::user()->enumIs('user_type', UserType::STORE)) {
        return $next($request);
      } else {
        return abort('403');
      }
    }

  }
}
