<?php

namespace App\Http\Middleware;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
class RedirectIfAuthenticated
{
  /**
   * Handle an incoming request.
   *
   * @param  \Illuminate\Http\Request  $request
   * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
   * @param  string|null  ...$guards
   * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
   */
  public function handle(Request $request, Closure $next, ...$guards)
  {
    if (Auth::check()) {
      $user = Auth::user();
      $home = match ($user->user_type) {
        'Admin' => '/admin/dashboard',
        'Store' => '/store/dashboard',
        default => '/dashboard',
      };

      return redirect()->intended($home);
    } else {
      $guards = empty($guards) ? [null] : $guards;
      foreach ($guards as $guard) {
        if (Auth::guard($guard)->check()) {
          return redirect('/');
        }
      }

      return $next($request);
    }

  }
}
