<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class Localization
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {

         if ($request->hasHeader("Accept-Language")) {
        /**
         * If Accept-Language header found then set it to the default locale
         */
        // Extract the first valid locale
        $localeHeader = request()->header('Accept-Language');
        $locale = explode(',', $localeHeader)[0]; // "en_US"
        // You may want to further sanitize:
        $locale = strtolower(str_replace('-', '_', $locale)); // "en_us" → optional
        app()->setLocale($locale);
        //app()->setLocale($request->header("Accept-Language"));
    }
        return $next($request);
    }
}
