<?Php
namespace App\Http\Middleware;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Traits\ApiResponseTrait;
class CheckUserStatus
{
  use ApiResponseTrait;
  public function handle(Request $request, Closure $next)
  {
    $user = Auth::user();
    if (!$user || $user->status === 0 || $user->status === 2) {
      //Revoke token for Sanctum
      $request->user()->currentAccessToken()->delete();
      return $this->unauthorizedResponse([], __('locale.Your account has been disabled or unauthorized.'));
    }
    return $next($request);
  }
}
