<?php
// app/Http/Middleware/BlockIfHighDues.php
namespace App\Http\Middleware;
use Illuminate\Support\Facades\Auth;
use App\Models\Wallet;
use App\Models\Store;
use App\Models\Driver;
use App\Enums\UserType;
use Closure;

class BlockIfHighDues
{
  public function handle($request, Closure $next, $guard = 'web', int $threshold = 1000)
  {
    $user = Auth::user();
    $ownerType = $user->user_type;
    $currency = $user->currency;
    if (Auth::user()->enumIs('user_type', UserType::STORE)) {
      $ownerId = Store::where('user_id', Auth::id())->value('id');
    } elseif (Auth::user()->enumIs('user_type', UserType::DRIVER)) {
      $ownerId = Driver::where('user_id', Auth::id())->value('id');
    } else {
      $ownerId = Auth::id();
    }
    $ownerType = strtolower($ownerType);
    $wallet = Wallet::where('owner_type', $ownerType)->where('owner_id', $ownerId)->first();
    if ($wallet && $wallet->pending_dues >= $threshold) {
      if ($request->is('api/*') || $request->expectsJson()) {
        return response()->json(['message' => "Pending dues {$currency}{$wallet->pending_dues} exceed threshold amount {$currency}{$threshold}. Please settle."], 423);
      }
      // For web users → redirect
      return redirect()->route('store.dashboard')->withErrors([
        'message' => "Pending dues {$currency}{$wallet->pending_dues} exceed threshold. Please settle."
      ]);
    }
    return $next($request);
  }
}
