<?php
namespace App\Http\Middleware;
use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use Carbon\Carbon;
class ActivityByUser
{
  public function handle($request, Closure $next)
  {

    $user = Auth::user();
    if ($user) {
      $userId = $user->id;
      // Keep user online in cache for 1 minute
      Cache::put('user-is-online-' . $userId, true, now()->addMinutes(1));
      // Update last_seen only if not updated in the last minute
      if (!Cache::has('last-seen-' . $userId)) {
        $user->update(['last_seen' => Carbon::now()]);
        Cache::put('last-seen-' . $userId, true, now()->addMinutes(1));
      }
    }
    return $next($request);
  }
}
