<?php
namespace App\Http\Controllers\admin;
use Illuminate\Http\Request;
use App\Models\Wallet;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Helpers\Helpers;
use App\Traits\JsonResponseTrait;
use App\Repositories\Contracts\WithdrawalRequestRepositoryInterface;
use App\Http\Requests\WithdrawalFormRequest;
class WithdrawalRequestController extends Controller
{
  use JsonResponseTrait;
  protected $withdrawalRequestRepository;

  function __construct(WithdrawalRequestRepositoryInterface $withdrawalRequestRepository)
  {
    if (auth()->check() && auth()->user()->order_type === 'admin') {
      $this->middleware('permission:wallet-list|wallet-create|wallet-edit|wallet-delete', ['only' => ['index', 'show', 'withdrawalListAll']]);
      $this->middleware('permission:wallet-create', ['only' => ['create']]);
      $this->middleware('permission:wallet-edit', ['only' => ['edit', 'update', 'changeStatus']]);
      $this->middleware('permission:wallet-delete', ['only' => ['destroy']]);
    }
    $this->withdrawalRequestRepository = $withdrawalRequestRepository;
  }
  public function index()
  {
    $user = auth()->user();
    $walletAmount = '';
    if ($user->user_type == 'Store') {
      $storeId = $user->storeId;
      $walletAmount = Wallet::where('owner_id', $storeId)->where('owner_type', 'store')
        ->first()?->balance;
      $currency = $user->currency;
      $customers = '';
      return view('admin.withdrawal_requests.index', compact('walletAmount', 'currency', 'customers'));
    } else {
      $customers = cacheRemember('dropdown_withdrawal_user', 600, function () {
        return DB::table('users')
          ->join('withdrawal_requests', 'users.id', '=', 'withdrawal_requests.user_id')
          ->distinct()
          ->orderBy('users.name')
          ->pluck('users.name', 'users.id');
      }, ['dropdown']);
      return view('admin.withdrawal_requests.index', compact('walletAmount', 'customers'));
    }
  }

  public function withdrawalListAll(Request $request)
  {
    Helpers::markNotificationsAsRead('Payment Withdrawal Request');
    return $this->withdrawalRequestRepository->allList($request);
  }

  public function store(WithdrawalFormRequest $request)
  {
    return $this->withdrawalRequestRepository->store($request, null);

  }

  public function changeStatus(Request $request)
  {
    $id = $this->withdrawalRequestRepository->changeStatus($request);
    return $this->successResponse([$id], __('locale.Withdrawal Request Status Changed Successfully'));
  }

}
