<?php
namespace App\Http\Controllers\admin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Traits\JsonResponseTrait;
use Illuminate\Support\Facades\DB;
use App\Repositories\Contracts\SosAlertRepositoryInterface;
use App\Http\Requests\SosAlertRequest;
class SosAlertController extends Controller
{
  use JsonResponseTrait;
  protected $sosRepository;
  function __construct(SosAlertRepositoryInterface $sosRepository)
  {
    if (auth()->check() && auth()->user()->order_type === 'admin') {
      $this->middleware('permission:sos-list|sos-create|sos-edit|sos-delete', ['only' => ['index', 'show', 'sosListAll']]);
      $this->middleware('permission:sos-create', ['only' => ['create', 'order']]);
      $this->middleware('permission:sos-edit', ['only' => ['edit', 'update', 'changeStatus']]);
      $this->middleware('permission:sos-delete', ['only' => ['destroy']]);
    }
    $this->sosRepository = $sosRepository;
  }
  public function index()
  {
    $customers = cacheRemember('dropdown_sos_user', 60, function () {
      return DB::table('sos_alerts')
        ->join('users', 'users.id', '=', 'sos_alerts.user_id')
        ->select('users.id', 'users.name')
        ->distinct()
        ->orderBy('users.name')
        ->pluck('users.name', 'users.id');
    }, ['dropdown']);
    return view('admin.sos.index', [
      'customers' => $customers,
    ]);
  }

  public function sosListAll(Request $request)
  {
    return $this->sosRepository->allList($request);
  }

  public function store(SosAlertRequest $request)
  {
    $wallet = $this->sosRepository->store($request, null);
    return $this->successResponse($wallet, __('locale.SOS Alert submitted successfully!'));
  }


}
