<?php
namespace App\Http\Controllers\admin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Support\Facades\View;
use Session;
use Helper;
use Illuminate\Support\Facades\File;
use App\Http\Requests\WebPushRequest;
use App\Models\WebpushSubscription;
use App\Http\Requests\DeveloperPasswordRequest;
class SettingController extends Controller
{
  function __construct()
  {
    $this->middleware('permission:site_Settings-list|site_Settings-create|site_Settings-edit|site_Settings-delete', ['only' => ['aboutUs', 'terms', 'privacyPolicy', 'help', 'siteSettings']]);
    $this->middleware('permission:site_Settings-create', ['only' => ['create', 'store', 'backups', 'checkDeveloperPassword']]);
    $this->middleware('permission:site_Settings-edit', ['only' => ['edit', 'update', 'postSetting', 'postSiteSetting']]);
    $this->middleware('permission:site_Settings-delete', ['only' => ['destroy']]);
    $this->middleware('permission:custom_Pages-list|custom_Pages-create|custom_Pages-edit|custom_Pages-delete', ['only' => ['aboutUs', 'terms', 'privacyPolicy', 'help']]);
  }

  public function aboutUs()
  {
    $data = Helper::setting('about_us', 'pages');
    return View::make('common.about-us')->with(compact('data'));
  }

  public function terms()
  {
    $data = Helper::setting('terms', 'pages');
    return View::make('common.terms')->with(compact('data'));
  }

  public function help()
  {
    $data = Helper::setting('help', 'pages');
    return View::make('common.help')->with(compact('data'));
  }

  public function privacyPolicy()
  {
    $data = Helper::setting('privacy_policy', 'pages');
    return View::make('common.privacy-policy')->with(compact('data'));
  }

  public function getTerms()
  {
    $terms = Helper::setting('terms', 'pages');
    return View::make('terms')->with(compact('terms'));
  }

  public function getPrivacyPolicy()
  {
    $policy = Helper::setting('privacy_policy', 'pages');
    return View::make('policy')->with(compact('policy'));
  }


  public function postSetting(Request $request)
  {
    $type = $request->type;
    $data = Setting::where('meta_key', $type)->firstOrFail();
    $data->meta_value = $request->content_data;
    $data->save();
    $result['message'] = __('locale.Content Uploaded Successfully');
    $result['status'] = 200;
    $result['data'] = $data;
    return $result;
  }

  public function siteSettings()
  {
    $data = array();
    $set = Setting::where('meta_type', 'site_setting')->orWhere('meta_type', 'social_links')->orWhere('meta_type', 'currency')->orWhere('meta_type', 'app_links')->orWhere('meta_type', 'referral')->get();
    foreach ($set as $key => $value) {
      $data[$value['meta_key']] = $value["meta_value"];
    }
    return View::make('common.site-settings')->with(compact('data'));
  }

  public function postSiteSetting(Request $request)
  {
    foreach ($request->all() as $key => $value) {
      $data = Setting::where('meta_key', $key)->first();
      if (!empty($data)) {
        $data->meta_value = $value;
        $data->save();
      }
    }
    $result['message'] = __('locale.Settings Uploaded Successfully');
    $result['status'] = 200;
    return $result;
  }



  public function backups()
  {
    $path = storage_path('app/private/' . config('app.name'));
    // Create the directory if it doesn't exist
    if (!File::exists($path)) {
      File::makeDirectory($path, 0755, true);
    }
    $files = File::files($path);
    $backups = [];
    // make an array of backup files, with their filesize and creation date
    foreach ($files as $k => $path) {
      $file = pathinfo($path);
      $backups[] = [
        'file_path' => $file['dirname'],
        'file_name' => $file['basename'],
        'file_size' => File::size($file['dirname'] . '/' . $file['basename']),
        'last_modified' => date("F d Y H:i", filemtime($file['dirname'] . '/' . $file['basename'])),
      ];
    }
    // reverse the backups, so the newest one would be on top
    $backups = array_reverse($backups);
    return View::make('common.backups')->with(compact('backups'));
  }

  public function getDownload($zipFileName)
  {
    $file = storage_path('app/private/' . config('app.name')) . "/" . $zipFileName;
    $headers = array(
      'Content-Type: application/octet-stream',
    );
    if (file_exists($file)) {
      return response()->download($file, $zipFileName, $headers);
    }
    return false;
  }

  public function update(Request $request)
  {
    foreach ($request->types as $key => $type) {
      $business_settings = Setting::where('meta_key', $type)->first();
      if ($business_settings != null) {
        $business_settings->meta_value = $request[$type];
        $business_settings->save();
      } else {
        $business_settings = new Setting;
        $business_settings->meta_key = $type;
        $business_settings->meta_value = $request[$type];
        $business_settings->save();
      }
    }
    Session::flash('success', __('locale.Settings updated successfully'));
    return back();
  }

  public function saveSubscription(WebPushRequest $request)
  {
    $data = $request->all();
    $user = auth()->user();
    $subscription = WebpushSubscription::updateOrCreate(
      [
        'subscribable_type' => get_class($user),
        'subscribable_id' => $user->id,
        'endpoint' => $data['endpoint']
      ],
      [
        'public_key' => $data['keys']['p256dh'],
        'auth_token' => $data['keys']['auth'],
        'content_encoding' => 'aes128gcm' // default encoding
      ]
    );

    return response()->json(['success' => true, 'message' => 'Subscription saved successfully']);
  }
  public function checkDeveloperPassword(DeveloperPasswordRequest $request)
  {
    $valid = $request->developer_password === config('app.DEVELOPER_PASSWORD');
    return response()->json(['valid' => $valid]);
  }
}
