<?php
namespace App\Http\Controllers\admin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Traits\JsonResponseTrait;
use App\Repositories\Contracts\RideRepositoryInterface;
class RideController extends Controller
{
  use JsonResponseTrait;
  protected $rideRepository;

  function __construct(RideRepositoryInterface $rideRepository)
  {
    if (auth()->check() && auth()->user()->order_type === 'admin') {
      $this->middleware('permission:ride-list|ride-create|ride-edit|ride-delete', ['only' => ['index', 'show', 'rideListAll', 'parcel']]);
      $this->middleware('permission:ride-create', ['only' => ['create', 'assignDriver']]);
      $this->middleware('permission:ride-edit', ['only' => ['edit', 'update', 'changeStatus']]);
      $this->middleware('permission:ride-delete', ['only' => ['destroy']]);
    }
    $this->rideRepository = $rideRepository;
  }
  public function index()
  {
    return view('admin.rides.index', [
      'customers' => $this->rideRepository->getRideCustomersDropdown(),
      'drivers' => $this->rideRepository->getRideDriversDropdown(),
    ]);
  }

  public function parcel()
  {
    return view('admin.rides.parcel', [
      'customers' => $this->rideRepository->getParcelCustomersDropdown(),
      'drivers' => $this->rideRepository->getParcelDriversDropdown(),
    ]);
  }
  public function delivery()
  {
    return view('admin.rides.delivery', [
      'customers' => $this->rideRepository->getParcelCustomersDropdown(),
      'drivers' => $this->rideRepository->getParcelDriversDropdown(),
    ]);
  }

  public function rideListAll(Request $request)
  {
    return $this->rideRepository->allList($request);
  }

  public function show($id)
  {
    $ride = $this->rideRepository->find($id);
    return view('admin.rides.show', compact('ride'));
  }

  public function assignDriver(Request $request, $orderId)
  {
    $driverId = $request->driver_id;
    $data = $this->rideRepository->assignDriver($orderId, $driverId);
    return $this->successResponse($data, __('locale.Driver assigned successfully'));
  }

}
