<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use App\Repositories\Contracts\RentalRepositoryInterface;
use App\Traits\JsonResponseTrait;
use Illuminate\Http\Request;
use App\Http\Requests\RentalRequest;
use App\Models\Rental;
class RentalController extends Controller
{
  use JsonResponseTrait;
  protected $rentalRepository;
  public function __construct(RentalRepositoryInterface $rentalRepository)
  {
    $this->middleware('permission:rental-list|rental-create|rental-edit|rental-delete', ['only' => ['index', 'show', 'rentalListAll']]);
    $this->middleware('permission:rental-create', ['only' => ['create', 'store', 'nextInstallment']]);
    $this->middleware('permission:rental-edit', ['only' => ['edit', 'update', 'changeStatus']]);
    $this->middleware('permission:rental-delete', ['only' => ['destroy']]);
    $this->rentalRepository = $rentalRepository;
  }

  public function index()
  {
    $data = $this->rentalRepository->allRentals();
    $cars = $data['cars'];
    $drivers = $data['drivers'];
    return view('admin.rentals.index', compact('cars', 'drivers'));
  }

  public function rentalListAll(Request $request)
  {
    return $this->rentalRepository->allList($request);
  }

  public function create()
  {
    return view('/admin/rentals/create');
  }
  public function edit(int $id)
  {
    $rental = Rental::with('installments')->find($id);
    $rental->installments_paid = $rental->installments->where('paid_amount', '>', 0)->isNotEmpty();
    $rental->paid_installments = $rental->installments->where('paid_amount', '>', 0)->count();
    return response()->json($rental);
  }
  public function show(Request $request, $id)
  {
    $rental = $this->rentalRepository->find($id);
    $breadcrumbs = [
      'Home' => route('admin.dashboard'),
      'Rental' => route('rentals.index'),
      $rental->car?->license_plate => null, // last one is active
    ];
    return view('/admin/rentals/show', compact('rental', 'id', 'breadcrumbs'));
  }

  public function store(RentalRequest $request)
  {
    $rental = $this->rentalRepository->store($request, null);
    return $this->successResponse($rental, __('locale.Rental data submitted successfully!'));
  }
  public function update(RentalRequest $request, int $id)
  {
    $rental = $this->rentalRepository->store($request, $id);
    return $this->successResponse($rental, __('locale.Rental data updated successfully!'));
  }

  public function changeStatus(Request $request, $id)
  {
    $status = $request->post('status');
    $this->rentalRepository->toggleStatus($id, $status);
    return $this->successResponse(['id' => $id, 'status' => $status], __('locale.Rental Status Changed Successfully'));
  }
  public function nextInstallment($rentalId)
  {
    $rental = $this->rentalRepository->nextInstallment($rentalId);
    return $this->successResponse($rental, __('locale.Rental data updated successfully!'));
  }

}
