<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use App\Http\Requests\PackageRequest;
use App\Repositories\Contracts\PackageRepositoryInterface;
use App\Traits\JsonResponseTrait;
class PackageController extends Controller
{
  use JsonResponseTrait;

  protected $packageRepository;

  public function __construct(PackageRepositoryInterface $packageRepository)
  {
    $this->middleware('permission:package-list|package-create|package-edit|package-delete', ['only' => ['index', 'show', 'packageListAll']]);
    $this->middleware('permission:package-create', ['only' => ['create', 'store']]);
    $this->middleware('permission:package-edit', ['only' => ['edit', 'update', 'changeStatus']]);
    $this->middleware('permission:package-delete', ['only' => ['destroy']]);

    $this->packageRepository = $packageRepository;
  }

  public function index()
  {
    $allPackages = $this->packageRepository->all();
    return view('admin.packages.index', compact('allPackages'));
  }

  public function packageListAll()
  {
    return $this->packageRepository->allPackages();
  }

  public function show($id)
  {
    $package = $this->packageRepository->find($id);
    return view('admin.packages.show', compact('package'));
  }

  public function store(PackageRequest $request)
  {
    $package = $this->packageRepository->store($request->validated());
    return $this->successResponse($package, __('locale.Package Uploaded Successfully'));
  }

  public function update(PackageRequest $request, $id)
  {
    $package = $this->packageRepository->update($id, $request->validated());
    return $this->successResponse($package, __('locale.Package Edited Successfully'));
  }

  public function dropdown()
  {
    return $this->packageRepository->dropdown();
  }

  public function destroy($id)
  {
    $this->packageRepository->delete($id);
    return $this->successResponse($id, __('locale.Package Deleted Successfully'));
  }

  public function changeStatus()
  {
    $package = $this->packageRepository->toggleStatus(request('id'), request('status'));
    return $this->successResponse($package, __('locale.Package Status Changes Successfully'));
  }


}
