<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Auth;
use Illuminate\Support\Facades\DB;
use App\Traits\JsonResponseTrait;
class NotificationController extends Controller
{
  use JsonResponseTrait;
  // ToDo App
  public function index($type = null)
  {
    $user = Auth::user();
    $notifiable_id = $user->id;

    //dd($notifiable_id);
    if (!empty($type)) {
      if ($type == 'All') {
        $message = __('locale.All Notifications');
        $notifications = DB::table('notifications')->where('notifiable_id', $notifiable_id)->Limit(100)->orderBy('created_at', 'desc')->get();
      } elseif ($type == 'Unread') {
        $message = __('locale.All Unread Notifications');
        $notifications = DB::table('notifications')->whereNull('read_at')->Limit(100)->where('notifiable_id', $notifiable_id)->orderBy('created_at', 'desc')->get();
      } elseif ($type == 'Read') {
        $message = __('locale.All Read Notifications');
        $notifications = DB::table('notifications')->whereNotNull('read_at')->Limit(100)->where('notifiable_id', $notifiable_id)->orderBy('created_at', 'desc')->get();
      } else {
        $message = __('locale.All Notifications of ') . $type;
        $notifications = DB::table('notifications')->where('notifiable_id', $notifiable_id)->whereJsonContains('data->head', $type)->Limit(100)->orderBy('created_at', 'desc')->get();
      }
      $html = ' <ul class="list-unstyled mb-2" id="todo-task-list">';
      if (!empty($notifications)) {
        foreach ($notifications as $key => $value) {
          $html .= $this->listNoti($value->id);
        }
      } else {
        $message = __('locale.No Notification Found');
      }
      return $this->successResponse($html, $message);

    } else {
      $notifications = $user->notifications;
    }
    return view('/common/app-notification')->with(compact('notifications'));
  }
  public function listNoti($id)
  {
    $noti = DB::table('notifications')->where('id', $id)->first();
    if (!$noti)
      return '';

    $json = json_decode($noti->data, true);
    $sender = \App\Models\User::find($json['sender_id']);
    $profilePhoto = $sender?->profile_photo_url ?? '';
    $time = Carbon::parse($noti->created_at)->diffForHumans();

    return '
        <li class="email-list-item email-marked-read d-flex align-items-center">
          <div class="d-flex align-items-center w-100">
            <div class="form-check mb-0 ms-2">
              <input class="email-list-item-input form-check-input" type="checkbox" id="email-' . $noti->id . '" />
              <label class="form-check-label" for="email-' . $noti->id . '"></label>
            </div>
            <div class="email-list-item-content ms-2 ms-sm-0 me-2">
              <span class="email-list-item-username me-2 text-heading">' . e($json['head']) . '</span>
              <span class="email-list-item-subject d-xl-inline-block d-block">' . e($json['body']) . '</span>
            </div>
            <div class="email-list-item-meta ms-auto d-flex align-items-center">
              <small class="email-list-item-time text-body-secondary">' . $time . '</small>
              <ul class="list-inline email-list-item-actions">
                <li class="list-inline-item email-unread btn btn-icon btn-text-secondary rounded-pill">
                  <i class="icon-base ti tabler-mail icon-md"></i>
                </li>
                <li class="list-inline-item email-delete btn btn-icon btn-text-secondary rounded-pill">
                  <i class="icon-base ti tabler-trash icon-md"></i>
                </li>
              </ul>
            </div>
          </div>
        </li>';
  }

  public function markRead(Request $request)
  {
    $ids = $request->input('ids');
    Auth::user()->unreadNotifications()->whereIn('id', $ids)->update(['read_at' => now()]);
    return $this->successResponse(null, __('locale.Notifications marked as read successfully.'));
  }

  public function delete(Request $request)
  {
    $ids = $request->input('ids');
    Auth::user()->notifications()->whereIn('id', $ids)->delete();
    return $this->successResponse(null, __('locale.Notifications Deleted successfully.'));
  }

  public function markAllRead(Request $request)
  {
    auth()->user()->unreadNotifications->markAsRead();
    return $this->successResponse(null, __('locale.Notifications marked as read successfully.'));
  }

}
