<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use App\Repositories\Contracts\InstallmentRepositoryInterface;
use App\Traits\JsonResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\InstallmentRequest;
class InstallmentController extends Controller
{
  use JsonResponseTrait;

  protected $packageRepository;

  public function __construct(InstallmentRepositoryInterface $packageRepository)
  {
    $this->middleware('permission:rental-list|rental-create|rental-edit|rental-delete', ['only' => ['index', 'show', 'installmentListAll']]);
    $this->middleware('permission:rental-create', ['only' => ['create', 'store']]);
    $this->middleware('permission:rental-edit', ['only' => ['edit', 'update', 'changeStatus']]);
    $this->middleware('permission:rental-delete', ['only' => ['destroy']]);

    $this->packageRepository = $packageRepository;
  }

  public function index()
  {
    $customers = cacheRemember('dropdown_installments_driver', 600, function () {
      return DB::table('installments')
        ->join('rentals', 'rentals.id', '=', 'installments.rental_id')
        ->join('drivers', 'drivers.id', '=', 'rentals.driver_id')
        ->join('users', 'users.id', '=', 'drivers.user_id')
        ->select('users.id', 'users.name')
        ->distinct()
        ->orderBy('users.name')
        ->pluck('users.name', 'users.id');
    }, ['dropdown']);
    return view('admin.installments.index', compact('customers'));
  }

  public function installmentListAll(Request $request)
  {
    return $this->packageRepository->allInstallments($request);
  }

  public function store(InstallmentRequest $request)
  {
    $rental = $this->packageRepository->store($request, null);
    return $this->successResponse($rental, __('locale.Installment data submitted successfully!'));
  }

  public function changeStatus(Request $request, $id)
  {
    $status = $request->post('status');
    $this->packageRepository->toggleStatus($id, $status);
    return $this->successResponse(['id' => $id, 'status' => $status], __('locale.Installment Status Changed Successfully'));
  }

}
